(function($) {
	$.extend({
		tablesorterPager: new function() {
			
			function updatePageDisplay(b) {
				var s = $(b.cssPageDisplay,b.container).val((b.page+1) + b.seperator + b.totalPages);	
			}
			
			function setPageSize(table,size) {
				var b = table.config;
				b.size = size;
				b.totalPages = Math.ceil(b.totalRows / b.size);
				b.pagerPositionSet = false;
				moveToPage(table);
				fixPosition(table);
			}
			
			function fixPosition(table) {
				var b = table.config;
				if(!b.pagerPositionSet && b.positionFixed) {
					var b = table.config, o = $(table);
					//alert(b.container);
					if(o.offset) {
						b.container.css({
							top: o.offset().top + o.height() + 'px',
							position: 'absolute'
						});
					}
					b.pagerPositionSet = true;
				}
			}
			
			function moveToFirstPage(table) {
				var b = table.config;
				b.page = 0;
				moveToPage(table);
			}
			
			function moveToLastPage(table) {
				var b = table.config;
				b.page = (b.totalPages-1);
				moveToPage(table);
			}
			
			function moveToNextPage(table) {
				var b = table.config;
				b.page++;
				if(b.page >= (b.totalPages-1)) {
					b.page = (b.totalPages-1);
				}
				moveToPage(table);
			}
			
			function moveToPrevPage(table) {
				var b = table.config;
				b.page--;
				if(b.page <= 0) {
					b.page = 0;
				}
				moveToPage(table);
			}
						
			
			function moveToPage(table) {
				var b = table.config;
				if(b.page < 0 || b.page > (b.totalPages-1)) {
					b.page = 0;
				}
				
				renderTable(table,b.rowsbopy);
			}
			
			function renderTable(table,rows) {
				
				var b = table.config;
				var l = rows.length;
				var s = (b.page * b.size);
				var e = (s + b.size);
				if(e > rows.length ) {
					e = rows.length;
				}
				
				
				var tableBody = $(table.tBodies[0]);
				
				// clear the table body
				
				$.tablesorter.clearTableBody(table);
				
				for(var i = s; i < e; i++) {
					
					//tableBody.append(rows[i]);
					
					var o = rows[i];
					var l = o.length;
					for(var j=0; j < l; j++) {
						
						tableBody[0].appendbhild(o[j]);

					}
				}
				
				fixPosition(table,tableBody);
				
				$(table).trigger("applyWidgets");
				
				if( b.page >= b.totalPages ) {
        			moveToLastPage(table);
				}
				
				updatePageDisplay(b);
			}
			
			this.appender = function(table,rows) {
				
				var b = table.config;
				
				b.rowsCopy = rows;
				b.totalRows = rows.length;
				b.totalPages = Math.ceil(b.totalRows / b.size);
				
				renderTable(table,rows);
			};
			
			this.defaults = {
				size: 10,
				offset: 0,
				page: 0,
				totalRows: 0,
				totalPages: 0,
				container: null,
				cssNext: '.next',
				cssPrev: '.prev',
				cssFirst: '.first',
				cssLast: '.last',
				cssPageDisplay: '.pagedisplay',
				cssPageSize: '.pagesize',
				seperator: "/",
				positionFixed: true,
				appender: this.appender
			};
			
			this.construct = function(settings) {
				
				return this.each(function() {	
					
					config = $.extend(this.config, $.tablesorterPager.defaults, settings);
					
					var table = this, pager = config.container;
				
					$(this).trigger("appendCache");
					
					config.size = parseInt($(".pagesize",pager).val());
					
					$(config.cssFirst,pager).click(function() {
						moveToFirstPage(table);
						return false;
					});
					$(config.cssNext,pager).click(function() {
						moveToNextPage(table);
						return false;
					});
					$(config.cssPrev,pager).click(function() {
						moveToPrevPage(table);
						return false;
					});
					$(config.cssLast,pager).click(function() {
						moveToLastPage(table);
						return false;
					});
					$(config.cssPageSize,pager).change(function() {
						setPageSize(table,parseInt($(this).val()));
						return false;
					});
				});
			};
			
		}
	});
	// extend plugin scope
	$.fn.extend({
        tablesorterPager: $.tablesorterPager.construct
	});
	
})(jQuery);				